# API Reference

**Must-have**
>The API reference must cover:
>- `addExtension`
>- `enableExtension`
>- `setExtensionProperty`
>- APIs related to the events reported by your extension. Be sure to describe each of the events in detail.

:::{admonition} Example
Below is an example of the API reference for `enableExtension`.
:::
## enableExtension
Enables the extension in the Agora SDK and inserts the extension to the transmission pipeline.
```
virtual int enableExtension(
      const char* provider_name, const char* extension_name, bool enable=true) = 0;
```
### Parameters
- `provider_name`: The name of the extension provider. <Tell customers your `provider_name` here>
- `extension_name`: The name of the extension. <Tell customers your `extension_name` here>
- `enable`: Whether to enable the extension:
    - `true`: (Default) Enable the extension.
    - `false`: Disable the extension.
### Returns
None.
